#include "IErrors.h"
#include <stdio.h>
#include <TextUtils.h>

//	void DoDebugError(const char * errorDescription, const char * fileName, long lineNumber)
//	
//	flags a debugging error
//	
//	errorDescription = description
//	fileName = source file name
//	lineNumber = source file number
void DoDebugError(const char * errorDescription, const char * fileName, long lineNumber)
{
	char buf[256];
	
	sprintf(buf, "Error in \"%s\" on line %ld: %s", fileName, lineNumber, errorDescription);
	CopyCStringToPascal(buf, (unsigned char *)buf);
	DebugStr((const unsigned char *)buf);
}

//	void DoDebugFatalError(const char * errorDescription, const char * fileName, long lineNumber)
//	
//	flags a fatal debugging error
//	
//	errorDescription = description
//	fileName = source file name
//	lineNumber = source file number
void DoDebugFatalError(const char * errorDescription, const char * fileName, long lineNumber)
{
	char buf[256];
	
	sprintf(buf, "Fatal Error in \"%s\" on line %ld: %s", fileName, lineNumber, errorDescription);
	CopyCStringToPascal(buf, (unsigned char *)buf);
	DebugStr((const unsigned char *)buf);
	
	ExitToShell();
}

//	void DoError(const char * errorDescription)
//	
//	flags a runtime error
//	
//	errorDescription = text description of error
void DoError(const char * errorDescription)
{
	Str255					buf;
	OSErr					theErr;
	SInt16					itemHit;
	ConstStringPtr			defaultText = "\pContinue";
	ConstStringPtr			cancelText = "\pQuit";
	ConstStringPtr			otherText = "\pDebugger";
	
	AlertStdAlertParamRec	theAlertInfo =
	{
		false,
		false,
		nil,
		defaultText,
		cancelText,
		otherText,
		kAlertStdAlertOKButton,
		kAlertStdAlertCancelButton,
		kWindowDefaultPosition
	};
	
	if(!HasMacsBug())
		theAlertInfo.otherText = nil;
	
	CopyCStringToPascal(errorDescription, buf);
	
	theErr = StandardAlert(kAlertCautionAlert, buf, nil, &theAlertInfo, &itemHit);
	
	if(theErr)
	{
		DebugStr("\pDoError: StandardAlert failed!");
		
		return;
	}
	
	if(itemHit == kAlertStdAlertCancelButton)
		ExitToShell();
	if(itemHit == kAlertStdAlertOtherButton)
		Debugger();
}

//	void DoFatalError(const char * errorDescription)
//	
//	flags a runtime fatal error
//	
//	errorDescription = text description of error
void DoFatalError(const char * errorDescription)
{
	Str255		buf;
	OSErr		theErr;
	SInt16		itemHit;
	ConstStringPtr			defaultText = "\pContinue";
	ConstStringPtr			cancelText = "\pQuit";
	ConstStringPtr			otherText = "\pDebugger";
	
	AlertStdAlertParamRec	theAlertInfo =
	{
		false,
		false,
		nil,
		defaultText,
		cancelText,
		otherText,
		kAlertStdAlertCancelButton,
		0,
		kWindowDefaultPosition
	};
	
	if(!HasMacsBug())
		theAlertInfo.otherText = nil;
	
	CopyCStringToPascal(errorDescription, buf);
	
	theErr = StandardAlert(kAlertStopAlert, buf, "\pWARNING: Fatal error  may go downhill quickly", &theAlertInfo, &itemHit);
	
	if(theErr)
	{
		DebugStr("\pDoFatalError: StandardAlert failed!");
		
		ExitToShell();
	}
	
	if(itemHit == kAlertStdAlertCancelButton)
		ExitToShell();
	if(itemHit == kAlertStdAlertOtherButton)
		Debugger();
}

//	void DoOSErr(const char * errorDescription, OSErr theErr)
//	
//	flags a runtime OSErr
//	
//	errorDescription = text description of error
//	theErr = OSErr
void DoOSErr(const char * errorDescription, OSErr theErr)
{
	if(!theErr)
		return;
	
	char buf[256];
	
	sprintf(buf, "%s (Error: %hd)", errorDescription, theErr);
	DoError(buf);
}

//	void DoFatalOSErr(const char * errorDescription, OSErr theErr)
//	
//	flags a fatal runtime OSErr
//	
//	errorDescription = text description of error
//	theErr = OSErr
void DoFatalOSErr(const char * errorDescription, OSErr theErr)
{
	if(!theErr)
		return;
	
	char buf[256];
	
	sprintf(buf, "%s (Error: %hd)", errorDescription, theErr);
	DoFatalError(buf);
}